package cn.smarthse.rho.modules.sys.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 *  短信验证码类型枚举
 *
 * @author wuxq
 * @since 2022/2/24年17:19月日
 */
@AllArgsConstructor
@Getter
public enum SmsCodeTypeEnum {

	/**
	 * 绑定企业
	 */
	BIND_COMPANY(1, "绑定企业"),
	/**
	 * 忘记密码
	 */
	FORGET_PWD(2, "忘记密码"),

	/**
	 * 其他
	 */
	OTHER(99, "其他");

	private Integer value;

	private String name;

	public static String getName(Integer index) {
		for (SmsCodeTypeEnum c : SmsCodeTypeEnum.values()) {
			if (c.getValue().equals(index)) {
				return c.name;
			}
		}
		return null;
	}
}
