package cn.smarthse.rho.modules.sys.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.time.temporal.ChronoUnit;


@AllArgsConstructor
@Getter
public enum RhoRiskCycleEnum {
    CM_CERT_1(1l,ChronoUnit.YEARS,"院区证书周期1"),
    CM_CERT_3(3l,ChronoUnit.YEARS,"院区证书周期3"),
    HC(2l,ChronoUnit.YEARS,"体检周期"),
    DOSE(RhoTimeEnum.SECOND_OF_90_DAY.getTime(),ChronoUnit.SECONDS,"个人剂量周期");

    private Long cycle;
    private ChronoUnit unit;
    private String name;

}
