package cn.smarthse.rho.modules.sys.entity.wanda;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

@Data
public class FswsErrorDataReturnLog implements Serializable {

    private String id;

    /**
     * 必填
     * FswsErrorDataTableTypeEnum
     */
    private String tableType;
    /**
     * 必填
     * 他们的id
     */
    private String tableId;
    /**
     * 必填
     * 万达仓数据入库时间load_time
     */
    private LocalDateTime bizTime;
    /**
     * 必填
     * FswsErrorDataErrTypeEnum
     */
    private Integer errType;
    /**
     * 必填
     * 原因
     */
    private String reason;
    /**
     * 万达仓数据创建时间
     */
    private LocalDateTime loadTime;

    private String uniqueid;
    /**
     * 是否需要推送（0-未推送 1-推送失败 2-推送成功）
     */
    private Integer needPush;
    /**
     * 最后推送时间
     */
    private LocalDateTime lastPushDate;

    public String getUniqueid() {
        return getNeedPush() + ":" + this.tableType + ":" + this.tableId + ":" + this.bizTime;
    }

    public Integer getNeedPush() {
        return Objects.isNull(this.needPush) ? 0 : this.needPush;
    }
}