package cn.smarthse.rho.modules.sys.entity.wanda;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;



/**
 * <p>
 * 院区推送表
 * </p>
 *
 * @author chenliang
 * @since 2024-12-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_company_push")
//@ApiModel(value="BCompanyPush对象", description="院区推送表")
public class BCompanyPush extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.ASSIGN_ID)
    private Long id;

    private String outId;

    //@ApiModelProperty(value = "职卫云加载时间")
    private LocalDateTime wandaLoadTime;

    //@ApiModelProperty(value = "放射卫生在线放射诊疗机构id")
    private String zwyHospitalId;

    //@ApiModelProperty(value = "数据来源（标记医院数据由哪一方录入产生：1-放射卫生在线，2-职卫云）")
    private String wandaDataSource;

    //@ApiModelProperty(value = "医院名称")
    private String name;

    //@ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    //@ApiModelProperty(value = "经营状态")
    private Integer businessStatus;

    //@ApiModelProperty(value = "工作地址行政区划")
    private Long areaId;

    //@ApiModelProperty(value = "工作作地址详情（eg：水墩新路88号）")
    private String address;

    //@ApiModelProperty(value = "工作地址完整（eg：浙江省杭州市上城区笕桥街道水墩新路88号）")
    private String fullAddress;

    //@ApiModelProperty(value = "注册地址")
    private String registeredFullAddress;

    //@ApiModelProperty(value = "操作类型：1-新增；2-更新；3-删除")
    private String optType;

    //@ApiModelProperty(value = "更新或删除的数据id，更新删除时必填")
    private String oldSourceId;

    //@ApiModelProperty(value = "更新或删除原因，更新删除时必填")
    private String optReason;

    //@ApiModelProperty(value = "0推送异常 1需要推送 2推送成功 3无需推送")
    private Integer pushStatus;

    //@ApiModelProperty(value = "推送异常失败原因")
    private String pushMsg;

    //@ApiModelProperty(value = "是否测试企业")
    private Integer isTest;



}
