package cn.smarthse.rho.modules.sys.entity.sys;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;

/**
 * 核素entity
 */
@Data
@TableName("sys_element")
public class SysElement implements Serializable{
	private static final long serialVersionUID = -3416906895729790255L;

	/**
	 * ID
	 */
	@TableId
	private Long id;

	/**
	 * 名称
	 */
	private String name;

	/**
	 * 符号
	 */
	private String symbol;

	/**
	 * 质子数
	 */
	private Integer protonNumber;

	/**
	 * 同位素标记
	 */
	private String neutrons;

	/**
	 * 核素状态
	 */
	private String energyState;

	/**
	 * 毒性因子
	 */
	private Float harmFactor;

	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Long updateBy;

	@TableLogic
	@TableField(select = true)
	private Integer isValid;
}
