package cn.smarthse.rho.modules.sys.entity.sys;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 操作记录
 *
 * @since 2024-08-16 08:47
 */
@Accessors(chain = true)
@TableName("sys_business_operate_log")
public @Data class SysBusinessOperateLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 模块
     */
    private Integer module;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 业务id
     */
    private Long businessId;

    /**
     * 操作类型
     */
    private Integer type;

    /**
     * 操作人
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String operator;

    /**
     * 操作人所在单位
     */
    private String operatorCompanyName;

    /**
     * 操作原因
     */
    private String reason;

    private Date createDate;
    private Long createBy;
    private Date updateDate;
    private Long updateBy;
    private Boolean isValid;

}
