
package cn.smarthse.rho.modules.sys.entity.r;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;


@EqualsAndHashCode(callSuper = true)
@Data
@TableName("r_risk_basic")
public class RRiskBasic extends BaseEntity implements Serializable {
    private static final long serialVersionUID = 5205909260757656502L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 机构id
     */
    private Long thirdOrgId;

    /**
     * 业务id
     */
    private Long businessId;

    /**
     * 风险名称
     */
    private String name;

    /**
     * 风险类型 （RiskTypeEnum）
     */
    private Integer type;

    /**
     * 类别（1-普通八项；2-异常六项）
     */
    private Integer category;

    /**
     * 推送年份
     */
    private Integer year;

    /**
     * 描述
     */
    private String description;

    /**
     * 附件
     */
    private String files;

    /**
     * 状态（1-未化解；2-已化解；3-已中止）
     */
    private Integer status;

    /**
     * 未化解状态(0-无；11-待整改；12-待验收；13-已退回)
     */
    private Integer unresolvedType;

    /**
     * 预警状态（1-首次预警；2-黄色预警；3-红色预警；4-启动执法）
     */
    private Integer warningStatus;

    /**
     * 是否由数据产生的风险（0-否；1-是）
     */
    private Integer isGenerateByData;


}
