package cn.smarthse.rho.modules.sys.entity.r;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


@EqualsAndHashCode(callSuper = true)
@Data
@TableName("r_risk_acceptance_record_history")
public class RRiskAcceptanceRecordHistory extends BaseEntity implements Serializable{
	@Serial
	private static final long serialVersionUID = 6212243856442013045L;
	
	/**
	 * ID
	 */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * r_risk_basic.id
	 */
	private Long riskId;

	/**
	 * r_risk_basic_source.id
	 */
	private Long sourceId;

	/**
	 * r_risk_acceptance_record.id
	 */
	private Long accId;
	
	/**
	 * 企业ID
	 */
	private Long cid;

	/**
	 * 风险类型 （RiskTypeEnum）
	 */
	private Integer riskType;

	/**
	 * 发现时间
	 */
	private LocalDateTime findTime;
	
	/**
	 * 整改负责人姓名（冗余）
	 */
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String reformDirectorName;
	
	/**
	 * 要求完成时间/整改期限
	 */
	private LocalDate requireFinishTime;
	
	/**
	 * 实际完成时间
	 */
	private LocalDate actualFinishTime;

	/**
	 * 整改提交时间
	 */
	private LocalDateTime submitTime;

	/**
	 * 佐证材料类型(AcceptanceMaterialsTypeEnum)
	 */
	private Integer materialsType;
	
	/**
	 * 整改相关资料/佐证材料
	 */
	private String reformFinishedFiles;
	
	/**
	 * 整改措施
	 */
	private String reformMeasure;
	
	/**
	 * 状态（0-草稿；1-待审核；2-无需整改；3-完成)
	 */
	private Integer status;
	
	/**
	 * 验收结论（1-通过；0-不通过）
	 */
	private Integer acceptanceResult;
	
	/**
	 * 验收结论说明
	 */
	private String acceptanceResultExplain;
	
	/**
	 * 验收负责人姓名（冗余）
	 */
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String acceptanceDirectorName;
	
	/**
	 * 验收时间
	 */
	private LocalDate acceptanceDate;
	/**
	 * 验收方式（RiskAcceptanceWayEnum）
	 */
	private Integer acceptanceWay;
	
	/**
	 * 验收相关资料
	 */
	private String acceptanceFiles;
	
	/**
	 * 诊断/体检机构id
	 */
	private Long thirdOrgId;
	
	/**
	 * 诊断/体检机构名称
	 */
	private String thirdOrgName;
	
	/**
	 * 诊断、体检时间开始
	 */
	private LocalDate dealTimeBegin;
	
	/**
	 * 处理措施
	 */
	private Integer dealMeasure;
	
	/**
	 * 诊断、体检时间结束
	 */
	private LocalDate dealTimeEnd;

	/**
	 * 体检-最近一次体检类型
	 */
	private Integer healthLastType;
	/**
	 * 体检-最近一次体/检测检时间
	 */
	private LocalDate businessLastDate;
	/**
	 * 体检-最近一次体检/复查/检测/个人剂量监测机构名称
	 */
	private String businessLastOrg;
	// /**
	//  * 最近一次 体检/检测 时间
	//  */
	// private LocalDate healthRecheckDate;
	/**
	 * 个人剂量-最近一次监测周期（开始）
	 */
	private LocalDate doseMonitorLastStartDate;
	/**
	 * 个人剂量-最近一次监测周期（结束）
	 */
	private LocalDate doseMonitorLastEndDate;
	/**
	 * 个人剂量-最近一次监测结果：小数
	 */
	private String doseLastResult;
	/**
	 * 最近一次 体检危害因素名称
	 */
	private String healthLastHazardFactor;
	/**
	 * 最近一次 体检结论
	 */
	private String healthLastCheckConclusion;
	/**
	 * 最近一次 体检适任性评价
	 */
	private String healthLastCheckAssessment;
	/**
	 * 检测-最近一次检测类型：1验收（控评）检测；2-状态（年度）检测；3-稳定性检测
	 */
	private Integer checkLastType;
	/**
	 * 检测-最近一次检测报告编号
	 */
	private String checkLastReportNo;
	/**
	 * 检测-最近一次检测结果：1-合格；0-不合格
	 */
	private Integer checkLastResult;
	/**
	 * 体检-离岗 时间
	 */
	private LocalDate offWorkDate;
	/**
	 * 暂时离岗 时间
	 */
	private LocalDate tempOffWorkDate;
	/**
	 * 暂时离岗 返岗时间
	 */
	private LocalDate tempReturnWorkDate;
	/**
	 * 许可-最近一次校验许可证号
	 */
	private String licenseLastNo;
}
