package cn.smarthse.rho.modules.sys.entity.g;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 安全装置和警示标识自检表
 * </p>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("g_safety_device_self_check")
public class GSafetyDeviceSelfCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 自检记录的唯一标识
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 医院ID，关联医院数据
     */
    private Long cid;

    /**
     * 自检时间
     */
    private LocalDateTime checkTime;

    /**
     * 佐证材料的文件ID
     */
    private Long certificateFile;

    /**
     * 承诺人姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    /**
     * 承诺人电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;

    /**
     * 承诺书文件ID
     */
    private Long commitmentFile;
    /**
     * 画像审核状态：默认1-已通过，2-被退回
     */
    private Integer status;
}
