package cn.smarthse.rho.modules.sys.entity.g;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 个人防护用品自检表
 * 表结构：g_equipment_self_check
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("g_equipment_self_check")
public class GEquipmentSelfCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 医院ID
     */
    private Long cid;

    /**
     * 自检时间
     */
    private LocalDateTime checkTime;

    /**
     * 佐证材料文件ID
     */
    private Long certificateFile;

    /**
     * 承诺人姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    /**
     * 承诺人电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;

    /**
     * 承诺书文件ID
     */
    private Long commitmentFile;
    /**
     * 画像审核状态：默认1-已通过，2-被退回
     */
    private Integer status;
}
