package cn.smarthse.rho.modules.sys.entity.f;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.util.Date;
import java.util.List;


/**
 * 医院：三同时项目详情
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@EqualsAndHashCode(callSuper = true)
@TableName("f_project_detail")
@Data
public class FProjectDetail extends BaseEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 三同时项目id
     */
    private Long projectId;

    /**
     * 类型（1-设备；2-场所）
     */
    private Integer type;

    /**
     * （1-进行中；2-已完成；3-合理缺项）
     */
    @TableField(exist = false)
    private Integer detailStatus;

    /**
     * 预控评，1-正常填写；2-合理缺项；
     */
    private Integer fillType;

    /**
     * 预评完成状态（0-未开展；1-进行中；2-已开展）
     */
    private Integer preStatus;

    /**
     * 预评技术服务机构id
     */
    private Long preTechId;

    /**
     * 预评技术服务机构名称
     */
    private String preTechName;

    /**
     * 预评报告编号
     */
    private String preReportNo;

    /**
     * 预评报告出具时间
     */
    private Date preReportDate;

    /**
     * 控评完成状态（0-未开展；1-进行中；2-已开展）
     */
    private Integer cvaStatus;

    /**
     * 控评技术服务机构id
     */
    private Long cvaTechId;

    /**
     * 控评技术服务机构名称
     */
    private String cvaTechName;

    /**
     * 控评报告编号
     */
    private String cvaReportNo;

    /**
     * 控评报告出具时间
     */
    private Date cvaReportDate;

    /**
     * 合理缺项理由原因
     */
    private String reason;

    /**
     * 检测报告编号（性能/场所）
     */
    private String checkReportNo;

    /**
     * 检测报告ids（性能/场所，英文逗号分隔）
     */
    private String checkReportIds;

    /**
     * 检测报告编号下载url（废弃）
     */
    private String checkReportUrl;

    /**
     * 检测报告文件（性能/场所）
     */
    @TableField(exist = false)
    private List<SysFileVo> checkReportFiles;

}
