package cn.smarthse.rho.modules.sys.entity.f;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.entity.e.EMachineRoom;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomListVo;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.util.Date;
import java.util.List;

/**
 * 三同时项目 对象
 */
@EqualsAndHashCode(callSuper = true)
@TableName("f_project")
@Data
public class FProject extends BaseEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 三同时项目基础信息ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 医院id
     */
    private Long cid;

    /**
     * 医院名称
     */
    private String cname;

    /**
     * 院区
     */
    private String cbranch;

    /**
     * 设备名称
     */
    private String name;

    /**
     * 项目性质（1-新建；2-扩建；3-改建；4-技术引进；5-技术改造；6-数据交换）
     */
    private Integer projectType;

    /**
     * 项目类型（放射治疗）
     */
    private Integer raType;

    /**
     * 职业病危害类别（1-一般；2-较重；3-严重）
     */
    private Integer occType;

    /**
     * 项目地址
     */
    private String address;

    /**
     * 项目内容
     */
    private String content;

    /**
     * 立项时间
     */
    private Date beginDate;

    /**
     * 竣工时间
     */
    private Date finishDate;

    /**
     * 项目状态（0-草稿；1-待审核；2-已完成；3-被退回）
     */
    private Integer status;

    /**
     * 设备id
     */
    private Long deviceId;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 设备类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
     */
    @TableField(exist = false)
    private Integer deviceType;

    /**
     * 射线装置类型id（骨密度仪：24）
     */
    @TableField(exist = false)
    private Integer category;

    /**
     * 设备移动类型(1-固定设备；2-移动设备；3-车载设备)
     */
    @TableField(exist = false)
    private Integer mobilityType;

    /**
     * 场所id（多个以 , 分隔）
     */
    private String roomId;

    /**
     * 场所编号
     */
    private String roomNo;

    /**
     * 场所名称
     */
    private String roomName;

    /**
     * 场所
     */
    @TableField(exist = false)
    private List<EMachineRoomListVo> roomList;

}
