
package cn.smarthse.rho.modules.sys.entity.e;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;


@EqualsAndHashCode(callSuper = true)
@Data
@TableName("e_source_sealed")
public class ESourceSealed extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 6797860194132840282L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 公司id
	 */
	private Long cid;
	
	/**
	 * 基础表id(e_device表id)
	 */
	private Long did;

	/**
	 * 国家编码
	 */
	private String nuclideUniqueCode;
	
	/**
	 * 出厂活度（底数，保留两位小数）
	 */
	private Float data1;
	
	/**
	 * 出厂活度（指数）
	 */
	private Integer data2;
	
	/**
	 * 活度测量日期
	 */
	private Date measurementDate;
	
	/**
	 * 出厂日期
	 */
	private Date productionDate;
	
	/**
	 * 负责人
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String personInCharge;
	
	


}
