package cn.smarthse.rho.modules.sys.entity.e;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("e_relation")
public class ERelation extends BaseEntity implements Serializable{
	private static final long serialVersionUID = -7851177555949822071L;
	

    @TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 放射源/核素id
	 */
	private Long sourceId;
	
	/**
	 * 机房id
	 */
	private Long roomId;
	
	/**
	 * 设备id
	 */
	private Long deviceId;

	/**
	 * 变更日期
	 */
	private LocalDateTime changeDate;
	
	/**
	 * 是否为当前生效的关系(0-不是；1-是)
	 */
	private Integer isCur;

	/**
	 * 三同时项目id（f_project.id）
	 */
	private Long projectId;

	/**
	 * 批次id
	 */
	private Long batchId;

	/**
	 * 变更前装置/机房名称
	 */
	private String beforeChangeName;

	/**
	 * 变更后装置/机房名称
	 */
	private String afterChangeName;

	/**
	 * 操作人name
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String operatorName;



}
