package cn.smarthse.rho.modules.sys.entity.e;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("e_machine_room_decoration_log")
public class EMachineRoomDecorationLog extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 5268780439761869669L;


    @TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 机房id
	 */
	private Long rid;
	
	/**
	 * 记录人
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String operator;
	
	/**
	 * 装修时间
	 */
	private Date decorationDate;

	/**
	 * 装修内容
	 */
	private String content;

}
