package cn.smarthse.rho.modules.sys.entity.e;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;


@EqualsAndHashCode(callSuper = true)
@Data
@TableName("e_machine_room")
public class EMachineRoom extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 546693835053227893L;
	

    @TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 院区id
	 */
	private Long cid;

	/**
	 * 多地址id（b_company_address.id）
	 */
	private Long addrId;
	
	/**
	 * 机房名称
	 */
	private String name;

	/**
	 * 机房编号
	 */
	private String roomCode;

	/**
	 * 流水号
	 */
	private Integer serialNo;

	/**
	 * 是否为车载机房（0-否；1-是）
	 */
	private Integer isOnboard;
	
	/**
	 * 工作场所级别(1-甲级；2-乙级；3-丙级)
	 */
	@TableField(updateStrategy = FieldStrategy.ALWAYS)
	private Integer level;

	/**
	 * 启用状态(0-未启用；1-已启用)
	 */
	private Integer enableStatus;

	/**
	 * 许可证状态(0-无；1-未许可；2-已许可)
	 */
	//@ApiModelProperty(value = "许可证状态(0-无；1-未许可；2-已许可)")
	private Integer licenseStatus;

	/**
	 * 已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)
	 */
	//@ApiModelProperty(value = "已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)")
	private Integer licenseStatusType;

	/**
	 * 预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)
	 */
	//@ApiModelProperty(value = "预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)")
	private Integer warningStatus;

	/**
	 * 数据来源(1-系统新增；2-外部对接；)
	 */
	private Integer dataSource;

	/**
	 * 职卫云机房场所id
	 */
	private String zwyId;

	/**
	 * 万达仓推送状态（1-未推送；2-推送成功；3-推送失败）
	 */
	private Integer wandaPushState;

	@TableField("out_id")
	private String outId;


}
