
package cn.smarthse.rho.modules.sys.entity.e;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;


@EqualsAndHashCode(callSuper = true)
@Data
@TableName("e_device_source")
public class EDeviceSource extends BaseEntity implements Serializable {
    private static final long serialVersionUID = 6964876778062130356L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 公司id
     */
    private Long cid;

    /**
     * 基础表id(e_device表id)
     */
    private Long did;

    /**
     * 型号
     */
    private String model;

    /**
     * 放射诊疗类别(1-X射线影像诊断；2-介入放射学；3-核医学；4-放射治疗)
     */
    private String diagnosisType;

    /**
     * 负责人
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String personInCharge;


}
