
package cn.smarthse.rho.modules.sys.entity.e;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;


@EqualsAndHashCode(callSuper = true)
@Data
@TableName("e_device_ray")
public class EDeviceRay extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 7724801396893204882L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 公司id
	 */
	private Long cid;
	
	/**
	 * 基础表id(e_device表id)
	 */
	private Long did;

	/**
	 * 射线装置类型id（sys_device_category）
	 */
	private Long category;

	/**
	 * 设备移动类型(1-固定设备；2-移动设备；3-车载设备)
	 */
	private Integer mobilityType;

	/**
	 * 是否为床边机(0-否；1-是)（mobility_type为2时才有值）
	 */
	private Integer isBedside;
	
	/**
	 * 放射诊疗类别(英文逗号分隔)(EdeviceDiagnosisTypeEnum)
	 */
	private String diagnosisType;
	
	/**
	 * 型号
	 */
	private String model;
	
	/**
	 * 主要参数
	 */
	private String parameters;
	
	/**
	 * 球管个数
	 */
	@TableField(updateStrategy = FieldStrategy.ALWAYS)
	private Integer bulbNum;
	
	/**
	 * 放射检查类型（EdeviceRayCheckTypeEnum）
	 */
	private Integer checkType;
	
	/**
	 * 出厂日期
	 */
	private Date productionDate;
	
	/**
	 * 安装单位
	 */
	@TableField(updateStrategy = FieldStrategy.ALWAYS)
	private String installationUnit;
	
	/**
	 * 负责人
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String personInCharge;
	
	


}
