package cn.smarthse.rho.modules.sys.entity.d;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.util.Date;



/**
 * 场所检测详情
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@EqualsAndHashCode(callSuper = true)
@TableName("d_location_check_data")
@Data
public class DLocationCheckData extends BaseEntity {

    @Serial
    private static final long serialVersionUID = -4271211910905302812L;


    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;


    /** 
     * 医院id
     */
    private Long cid;


    /** 
     * 检测主表ID
     */
    private Long checkId;


    /** 
     * 所在院区名称
     */
    private String hospital;


    /** 
     * 院区的全国唯一编码
     */
    private String hospitalCode;


    /** 
     * 场所id
     */
    private Long locationId;


    /** 
     * 所在场所
     */
    private String locationName;


    /** 
     * 所在院区
     */
    private String companyBranch;


    /** 
     * 检测结果：0-不合格；1-合格；
     */
    private Integer checkResult;


    /** 
     * 检测时间(冗余)
     */
    private Date checkTime;

    /**
     * 检测数据来源(1-万达；2-佐证材料)
     */
    private Integer sourceFrom;

}
