package cn.smarthse.rho.modules.sys.entity.d;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;




/**
 * 场所检测
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
//@ApiModel(value = "场所检测记录 对象", description = "医院：场所检测")
@EqualsAndHashCode(callSuper = true)
@TableName("d_location_check")
@Data
public class DLocationCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;


    /**
     *医院id
     */
    private Long cid;

    /** 
     * 检测机构名称
     */
    private String orgName;

    /**
     * 检测机构信用代码
     */
    private String orgCode;


    /**
     * 所在院区名称
     */
    private String hospital;

    /**
     * 院区的全国唯一编码
     */
    private String hospitalCode;

    /**
     * 检测类型（1-控评检测；2-年度检测；）
     */
    private Integer type;

    /**
     * 检测时间
     */
    private Date checkTime;

    /**
     * 报告编号
     */
    private String reportNo;

    /**
     * 报告url
     */
    private String reportUrl;

    /**
     * 检测数据来源(1-万达；2-佐证材料)
     */
    private Integer sourceFrom;

}
