package cn.smarthse.rho.modules.sys.entity.d;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.util.Date;




/**
 * 性能检测详情
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
//@ApiModel(value = "性能检测记录详情 对象", description = "医院：性能检测设备详情")
@EqualsAndHashCode(callSuper = true)
@TableName("d_device_check_data")
@Data
public class DDeviceCheckData extends BaseEntity {

    @Serial
    private static final long serialVersionUID = 1974834377282853838L;


    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;


    /**
     * 医院id
     */
    private Long cid;


    /**
     * 性能检测主表id
     */
    private Long checkId;


    /**
     * 设备id
     */
    private Long deviceId;

    /**
     * 设备类型
     */
    @TableField(exist = false)
    private Integer deviceType;


    /**
     * 所在院区名称
     */
    private String hospital;


    /**
     * 院区的全国唯一编码
     */
    private String hospitalCode;


    /**
     * 设备名称
     */
    private String deviceName;


    /**
     * 设备型号
     */
    private String typeNo;


    /**
     * 出厂编号
     */
    private String factoryNo;


    /**
     * 所在场所
     */
    private String location;


    /**
     * 检测结果：0-不合格；1-合格；
     */
    private Integer checkResult;


    /**
     * 检测时间(冗余)
     */
    private Date checkTime;

    /**
     * 检测数据来源(1-万达；2-佐证材料)
     */
    private Integer sourceFrom;

}
