package cn.smarthse.rho.modules.sys.entity.d;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.util.Date;




/**
 * 性能检测
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@EqualsAndHashCode(callSuper = true)
@TableName("d_device_check")
@Data
public class DDeviceCheck extends BaseEntity {

    @Serial
    private static final long serialVersionUID = -8663238138511272833L;
    
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    
    /**
     * 医院id
     */
    private Long cid;

    
    /**
     * 检测机构名称
     */
    private String orgName;

    
    /**
     * 检测机构信用代码
     */
    private String orgCode;

    
    /**
     * 所在院区名称
     */
    private String hospital;

    
    /**
     * 院区的全国唯一编码
     */
    private String hospitalCode;

    
    /**
     * 检测类型（1-状态检测；2-验收检测；3-稳定性检测；）
     */
    private Integer type;

    
    /**
     * 检测时间
     */
    private Date checkTime;

    
    /**
     * 报告编号
     */
    private String reportNo;

    
    /**
     * 报告url
     */
    private String reportUrl;

    /**
     * 检测数据来源(1-万达；2-佐证材料)
     */
    private Integer sourceFrom;
    
}
