package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.enums.staff.StaffCertSourceEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertAuditStatusEnum;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * <p>
 * 员工：放射卫生培训概要
 * </p>
 *
 * @author chenliang
 * @since 2024-06-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("c_training_cert")
//@ApiModel(value = "CTrainingCert对象", description = "员工：放射卫生培训概要")
public class CTrainingCert extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //@ApiModelProperty(value = "培训系统培训id")
    private Long sourceTrainingId;

    //@ApiModelProperty(value = "培训系统用户报名id")
    private Long sourceEnrollId;

    //@ApiModelProperty(value = "培训系统证书id")
    private Long sourceCertId;

    //@ApiModelProperty(value = "培训系统人员id")
    private Long sourceStaffId;

    //@ApiModelProperty(value = "医院id")
    private Long cid;

    //@ApiModelProperty(value = "院区名称")
    private String compName;

    //@ApiModelProperty(value = "员工id")
    private Long staffId;

    //@ApiModelProperty("人员基础信息id")
    private Long staffBaseInfoId;

    //@ApiModelProperty(value = "员工姓名")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String staffName;

    //@ApiModelProperty(value = "员工姓名（现在）")
    @TableField(exist = false)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String staffNameNow;

    //@ApiModelProperty(value = "身份证")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    private String idcardType;

    private Integer sex;

    private LocalDate birthday;

    //@ApiModelProperty(value = "机构id")
    private Long techId;

    //@ApiModelProperty(value = "机构名称")
    private String techName;

    //@ApiModelProperty(value = "证书类型：1-放射卫生防护管理人员培训证；2-放射防护培训合格证；4-生态环境辐射培训证书")
    private Integer certType;

    private Integer trainingWay;

    //@ApiModelProperty(value = "证书编号")
    private String certNo;

    //@ApiModelProperty(value = "取证日期")
    private LocalDate issuanceDate;

    //@ApiModelProperty(value = "复审日期")
    private LocalDate reviewDate;

    //@ApiModelProperty(value = "证书有效期")
    private LocalDate certValidDate;

    //@ApiModelProperty(value = "培训名称")
    private String trainingName;

    //@ApiModelProperty(value = "培训开始时间")
    private LocalDate trainingBeginDate;

    //@ApiModelProperty(value = "培训结束时间")
    private LocalDate trainingEndDate;

    //@ApiModelProperty(value = "培训类型：1-初训；2-复训")
    private String trainingType;

    //@ApiModelProperty(value = "考核结果（0不合格，1合格）")
    private Integer result;

    //@ApiModelProperty(value = "培训内容")
    private String trainingContent;

    //@ApiModelProperty(value = "培训学时")
    private String trainingHours;

    //@ApiModelProperty(value = "来源")
    private Integer source;
    //@ApiModelProperty(value = "来源")
    @TableField(exist = false)
    private String sourceName;

    //@ApiModelProperty(value = "证书附件id")
    private Long certFileId;

    //@ApiModelProperty(value = "证书附件url")
    private String certFileUrl;

    //@ApiModelProperty(value = "附件名称")
    private String certFileName;

    //@ApiModelProperty(value = "审核状态")
    private Integer auditStatus;

    //迁移类型（0非迁移 1迁移）
    private Integer relocateType;
    //迁移原始id
    private Long relocatePrimitiveId;
    //迁移源id
    private Long relocateSourceId;
    //由于表cid很容易被误修改，这里冗余迁移cid字段，用于应急溯源，每次迁移会更新
    private Long relocateTargetCid;

    //@ApiModelProperty(value = "审核状态")
    @TableField(exist = false)
    private String auditStatusStr;


    @TableField(exist = false)
    //@ApiModelProperty("关键因素画像审核id")
    private Long keyFactorAuditId;

    //@ApiModelProperty(value = "所在医院名称")
    @TableField(exist = false)
    private String hospitalName;

    public String getSourceName() {
        return StaffCertSourceEnum.getName(this.source);
    }

    public String getAuditStatusStr() {
        return TrainingCertAuditStatusEnum.getNameByValue(this.auditStatus);
    }
}
