package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;



/**
 * <p>
 * 员工：工作经历
 * </p>
 *
 * @author chenliang
 * @since 2024-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("c_staff_work_experience")
//@ApiModel(value="CStaffWorkExperience对象", description="员工：工作经历")
public class CStaffWorkExperience extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //@ApiModelProperty(value = "单位id")
    @TableField("cid")
    private Long cid;

    //@ApiModelProperty(value = "部门id")
    @TableField("org_id")
    private Long orgId;

    @TableField("org_name")
    private String orgName;

    //废弃
    @TableField("staff_id")
    private Long staffId;

    //@ApiModelProperty(value = "c_staff_base_info.id")
    private Long staffBaseInfoId;

    //@ApiModelProperty(value = "工作经历类型：0离岗 1上岗 2转岗")
    @TableField("type")
    private Integer type;

    //@ApiModelProperty(value = "岗位/工种")
    @TableField("post")
    private Long post;

    //@ApiModelProperty(value = "岗位/工种")
    @TableField("post_name")
    private String postName;

    //@ApiModelProperty(value = "岗位状态（0离岗 1在岗）")
    @TableField("post_status")
    private Integer postStatus;

    //@ApiModelProperty(value = "职业照射种类及代码")
    @TableField("ra_type")
    private String raType;

    //@ApiModelProperty(value = "上岗时间")
    @TableField("post_start_time")
    private LocalDateTime postStartTime;

    //@ApiModelProperty(value = "离岗时间")
    @TableField("post_departure_time")
    private LocalDateTime postDepartureTime;

    //@ApiModelProperty(value = "暂时离岗时间")
    @TableField("tp_post_departure_time")
    private LocalDateTime tpPostDepartureTime;

    //@ApiModelProperty(value = "预上岗时间")
    @TableField("pre_post_start_time")
    private LocalDateTime prePostStartTime;

    //是否上岗（上岗）
    @TableField("is_on_job_transfer")
    private Integer isOnJobTransfer;

    //是否上岗（离岗）
    @TableField("is_post_job_transfer")
    private Integer isPostJobTransfer;

}
