package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 许可变更操作记录
 * </p>
 *
 * @author author
 * @since 2025-11-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("c_staff_relocation_log")
public class CStaffRelocationLog extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 4473679423757288238L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 人员id
     */
    private Long staffBaseInfoId;

    /**
     * 迁出院区id
     */
    private Long beCid;

    /**
     * 迁入cid
     */
    private Long toCid;

    /**
     * 操作时间
     */
    private LocalDateTime optTime;

    /**
     * 操作人id
     */
    private Long optId;

    /**
     * 操作人
     */
    private String optor;



}
