package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 人员：信息异常表
 * </p>
 *
 * @author author
 * @since 2025-10-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("c_staff_error")
public class CStaffError extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @TableField("cid")
    private Long cid;

    @TableField("staff_base_info_id")
    private Long staffBaseInfoId;

    /**
     * 人员类型（0普通 1放射工作人员）
     */
    @TableField("staff_type")
    private Integer staffType;

    /**
     * 人员类型（0普通 1管理人员）
     */
    @TableField("manager_type")
    private Integer managerType;

    /**
     * 身份证 0正常 1空 2格式错误
     */
    @TableField("idcard_err")
    private Integer idcardErr;

    /**
     * 手机号 0正常 1空 2格式错误
     */
    @TableField("phone_err")
    private Integer phoneErr;

    /**
     * 职业照射种类及代码 0正常 1空
     */
    @TableField("ra_type_err")
    private Integer raTypeErr;

    /**
     * 岗位 0正常 1空
     */
    @TableField("post_err")
    private Integer postErr;

    /**
     * 岗位状态 0正常 1空
     */
    @TableField("post_status_err")
    private Integer postStatusErr;

    /**
     * 机构 0正常 1空
     */
    @TableField("org_err")
    private Integer orgErr;

    /**
     * 工作经历 0正常 1空 2岗位状态为“离岗”，但最近一条工作经历中未填写离岗时间
     */
    @TableField("we_err")
    private Integer weErr;
    /**
     * 成为放射工作人员时间 0正常 1空
     */
    @TableField("ray_staff_time_err")
    private Integer rayStaffTimeErr;



}
