package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 个人剂量监测-审核记录
 * </p>
 *
 * @author author
 * @since 2025-11-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("c_dose_data_audit_log")
public class CDoseDataAuditLog extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 6490866107059780322L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    private Long doseDataId;

    /**
     * 1提交 2通过 3退回
     */
    private Integer optType;

    /**
     * 操作时间
     */
    private LocalDateTime optTime;

    /**
     * 操作人id
     */
    private Long optUserId;

    /**
     * 操作人名称
     */
    private String optUserName;

    /**
     * 退回原因
     */
    private String returnReason;




}
