package cn.smarthse.rho.modules.sys.entity.c;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 个人剂量监测人员详情
 *
 * @author wuxq
 * @since 2024/4/11 16:20
 */
//@ApiModel(value = "个人剂量监测人员详情 对象", description = "医院：个人剂量监测人员详情")
@EqualsAndHashCode(callSuper = true)
@TableName("c_dose_data")
@Data
public class CDoseData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("ID")
    @TableId
    private Long id;

    //@ApiModelProperty("fsws_dose_monitor_data.id")
    private String sourceId;

    //@ApiModelProperty("fsws_dose_monitor_data.check_id")
    private String sourceCheckId;

    //@ApiModelProperty("fsws_dose_monitor_data.load_time")
    private LocalDateTime sourceLoadTime;

    //@ApiModelProperty("fsws_dose_monitor_data.zwy_hospital_id")
    private String sourceCid;

    //数据来源DoseSourceEnum
    private String source;

    //审核状态AuditStatusEnum
    private Integer auditStatus;
    //退回原因
    private String returnReason;

    //@ApiModelProperty("主表ID")
    private Long baseId;

    //@ApiModelProperty("医院id")
    private Long cid;

    //@ApiModelProperty("人员基础信息id")
    private Long staffBaseInfoId;

    //@ApiModelProperty("姓名")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String name;

    private String idcardType;

    //@ApiModelProperty("身份证")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    //@ApiModelProperty("性别 0-女；1-男")
    private Integer sex;

    //@ApiModelProperty("年龄")
    private Integer age;

    //@ApiModelProperty("部门/科室")
    private String dept;

    //@ApiModelProperty("岗位/工种")
    private String post;

    //@ApiModelProperty("射线类型")
    private String raType;

    //@ApiModelProperty("职业照射种类及代码")
    private String exposureType;

    //@ApiModelProperty("监测机构id")
    private Long techId;

    //@ApiModelProperty("监测机构名称")
    private String techName;

    //@ApiModelProperty("时间")
    private LocalDate checkDate;

    //@ApiModelProperty("监测周期：开始")
    private LocalDate beginDate;

    //@ApiModelProperty("监测周期：结束")
    private LocalDate endDate;

    //@ApiModelProperty("监测结果")
    private String result;

    //@ApiModelProperty("年度剂量结果")
    private String doseResult;

    //@ApiModelProperty("超剂量调查报告url")
    private String bigDoseReport;

    //@ApiModelProperty("超剂量调查报告名称")
    private String bigDoseReportName;

    //@ApiModelProperty("是否超剂量")
    private Boolean isBigDose;

    //@ApiModelProperty("是否年度超剂量")
    private Boolean isYearBigDose;

    //@ApiModelProperty("超剂量调查状态")
    private String investigateStatus;

    //是否是佐证材料
    private Integer isSdFile;

    //佐证材料
    private Long sdFileId;

    //迁移类型（0非迁移 1迁移）
    private Integer relocateType;
    //迁移原始id
    private Long relocatePrimitiveId;
    //迁移源id
    private Long relocateSourceId;
    //由于表cid很容易被误修改，这里冗余迁移cid字段，用于应急溯源，每次迁移会更新
    private Long relocateTargetCid;
    //@ApiModelProperty("超剂量调查人")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String investigator;

    //@ApiModelProperty("处理状态：0-未处理；1-已处理")
    private Integer dealStatus;


    @TableField(exist = false)
    //@ApiModelProperty(value = "过期时间", hidden = true)
    private LocalDate expireTime;

    @TableField(exist = false)
    //@ApiModelProperty(value = "报告编号", hidden = true)
    private String reportNo;

    public String getIdcard() {
        return StrUtil.toUpperCase(idcard);
    }

}
