package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;



/**
 * <p>
 * 员工：证书
 * </p>
 *
 * @author chenliang
 * @since 2024-07-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("c_cert")
//@ApiModel(value = "CCert对象", description = "员工：证书")
public class CCert extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //@ApiModelProperty(value = "人员基础信息id")
    private Long baseId;

    private Long qxAreaId;

    //@ApiModelProperty("地市简称")
    private String cityShortNamePy;

    //@ApiModelProperty("县区简称")
    private String areaShortNamePy;

    //@ApiModelProperty("流水号年份")
    private Integer serialYear;

    //@ApiModelProperty("流水号")
    private Integer serialNo;

    //@ApiModelProperty(value = "放射人员工作证编码")
    private String raCert;

    //@ApiModelProperty(value = "放射人员工作证链接")
    private String raCertUrl;

    //@ApiModelProperty(value = "放射人员工作证文件id")
    private Long raCertFileId;

    //@ApiModelProperty(value = "职业照射种类及代码")
    private String raType;

    //@ApiModelProperty(value = "姓名")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    //@ApiModelProperty(value = "身份证")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    //@ApiModelProperty(value = "出生日期(来自身份证)")
    private LocalDate birthday;

    //@ApiModelProperty(value = "性别 0-女；1-男（来自身份证）")
    private Integer sex;

    //@ApiModelProperty(value = "头像id")
    private Long headId;

    //@ApiModelProperty(value = "头像链接")
    private String headUrl;

    //@ApiModelProperty(value = "体检时间")
    private LocalDate healthCheckTime;

    //@ApiModelProperty(value = "个人剂量监测时间")
    private LocalDate doseCheckTime;
    private LocalDate doseBeginTime;
    private LocalDate doseEndTime;

    //@ApiModelProperty(value = "培训时间")
    private LocalDate trainingTime;

    //@ApiModelProperty(value = "工作单位id")
    private Long cid;

    //@ApiModelProperty(value = "工作单位")
    private String cname;

    //@ApiModelProperty(value = "工作单位id(主院)")
    private Long mainCid;

    //@ApiModelProperty(value = "工作单位id(分院))")
    private Long branchCid;

    //@ApiModelProperty(value = "工作单位名称(主院)")
    private String mainCname;

    //@ApiModelProperty(value = "工作单位名称(分院))")
    private String branchCname;

//    //@ApiModelProperty(value = "证书编码")
//    private String certNo;

    //@ApiModelProperty(value = "发证单位id")
    private Long issueUnitId;

    //@ApiModelProperty(value = "发证单位名称")
    private String issueUnitName;

    //@ApiModelProperty(value = "发证时间")
    private LocalDate issueTime;

    //@ApiModelProperty(value = "更新时间")
    private LocalDateTime editTime;
}
