package cn.smarthse.rho.modules.sys.entity.bind;


import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
@TableName("sys_user_bind_log")
@Data
public class SysUserBindLog extends BaseEntity implements Serializable{

    private static final long serialVersionUID = 1L;
    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 公司id
     */
    private Long cid;

    /**
     * 账号id
     * 用户表id
     */
    private Long userId;

    /**
     * 绑定联系人
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String bindName;

    /**
     * 绑定手机号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String bindTel;

    /**
     * 系统来源,UserSystemWideEnum
     */
    private Integer systemSource;

    /**
     * 记录类型，UserBindLogTypeEnum
     */
    private Integer type;

    /**
     * 审核状态 ContactBindAuditStatusEnum
     */
    private Byte auditState;

    /**
     * 佐证材料id
     */
    private Long evidenceId;

}
