package cn.smarthse.rho.modules.sys.entity.bind;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("sys_user_bind")
public class SysUserBind extends BaseEntity implements Serializable{

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 公司id
     */
    private Long cid;

    /**
     * 用户表id
     */
    private Long userId;

    /**
     * 绑定联系人
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String bindName;

    /**
     * 绑定手机号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String bindTel;

    /**
     * 绑定人员 c_staff_base_info.id
     */
    private Long baseId;

    /**
     * 系统来源参考UserSystemWideEnum
     */
    private Integer systemSource;

    /**
     * 是否是重点关注的联系人
     */
    private Byte isFocus;
}
