package cn.smarthse.rho.modules.sys.entity.bind;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("contact_rebind_appeal")
public class ContactRebindAppeal extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 当前联系人姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String currentContactName;

    /**
     * 当前联系人电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String currentContactPhone;

    /**
     * 新联系人姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String newContactName;

    /**
     * 新联系人电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String newContactPhone;

    /**
     * 佐证材料ID，对应 sys_file 表主键
     */
    private Long evidenceId;

    /**
     * 提交时间
     */
    private Date submitTime;

    /**
     * 审核状态：
     */
    private Integer auditStatus;

    /**
     * 系统范围（参考 UserSystemWideEnum）
     */
    private Integer systemWide;
}
