
package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 *
 * 单位：统计表
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/7 8:45
 */
@EqualsAndHashCode(callSuper = true)
public @Data class BStatistic extends BaseEntity {

	private static final long serialVersionUID = 1L;

	private String id;
	/**
	 * cid
	 */
	private Long cid;
	/**
	 * 员工数量
	 */
	private Integer staffNum;
	/**
	 * 性能检测结果（1-最近一次检测存在超标，0-不存在超标）
	 */
	private Integer checkDeviceResultLast;
	/**
	 * 性能检测结果（1-最近一次检测存在超标，2-历次检测存在超标，3-不存在超标，4-无检测结果）
	 */
	private Integer checkDeviceResult;
	/**
	 * 场所检测结果（1-最近一次检测存在超标，0-不存在超标）
	 */
	private Integer checkLocationResultLast;
	/**
	 * 场所检测结果（1-最近一次检测存在超标，2-历次检测存在超标，3-不存在超标，4-无检测结果）
	 */
	private Integer checkLocationResult;
	/**
	 * 最近一次检测机构名
	 */
	private String checkOrg;
	/**
	 * 最近一次检测日期
	 */
	private java.util.Date checkDate;
	/**
	 * 个人剂量监测结果
	 */
	private Integer doseResult;
	/**
	 * 最近一次监测机构名
	 */
	private String doseOrg;
	/**
	 * 最近一次监测日期
	 */
	private java.util.Date doseDate;
	
	
	/**
	 * 风险化解完成数量：许可管理
	 */
	private Integer harmCertDone;
	/**
	 * 风险化解完成数量：性能检测
	 */
	private Integer harmCheckDeviceDone;
	/**
	 * 风险化解完成数量：场所检测
	 */
	private Integer harmCheckLocationDone;
	/**
	 * 风险化解完成数量：职业健康体检
	 */
	private Integer harmHealthDone;
	/**
	 * 风险化解完成数量：放射防护培训
	 */
	private Integer harmTrainingDone;
	/**
	 * 风险化解完成数量：个人剂量监测
	 */
	private Integer harmDoseDone;
	/**
	 * 风险化解完成数量：三同时
	 */
	private Integer harmThirdDone = 0;


	/**
	 * 风险总数：许可管理
	 */
	private Integer harmCertTotal;
	/**
	 * 风险总数：性能检测
	 */
	private Integer harmCheckDeviceTotal;
	/**
	 * 风险总数：场所检测
	 */
	private Integer harmCheckLocationTotal;
	/**
	 * 风险总数：职业健康体检
	 */
	private Integer harmHealthTotal;
	/**
	 * 风险总数：放射防护培训
	 */
	private Integer harmTrainingTotal;
	/**
	 * 风险总数：个人剂量监测
	 */
	private Integer harmDoseTotal;
	/**
	 * 风险总数：三同时
	 */
	private Integer harmThirdTotal = 0;
	
	

	/**
	 * 风险数
	 */
	private Integer harmNum;
	/**
	 * 风险未化解数
	 */
	private Integer harmNumUnfix;
	/**
	 * 风险已化解数
	 */
	private Integer harmNumFix;
	/**
	 * 风险已化解数（首次预警）
	 */
	private Integer harmNumFix1;
	/**
	 * 风险已化解数（黄色预警）
	 */
	private Integer harmNumFix2;
	/**
	 * 风险已化解数（红色预警）
	 */
	private Integer harmNumFix3;
	/**
	 * 风险已化解数（启动执法）
	 */
	private Integer harmNumFix4;
	/**
	 * 风险首次预警
	 */
	private Integer harmNumWarning1;
	/**
	 * 风险黄色预警
	 */
	private Integer harmNumWarning2;
	/**
	 * 风险红色预警
	 */
	private Integer harmNumWarning3;
	/**
	 * 风险启动执法
	 */
	private Integer harmNumWarning4;
	/**
	 * 放射防护培训
	 */
	private Integer trainingNum;
	/**
	 * 体检：体检结果(1-有；0-无)
	 */
	private Integer healthResult;
	/**
	 * 体检：存在疑是职业病（1-存在；0-不存在）
	 */
	private Integer healthResult3;
	/**
	 * 体检：存在职业禁忌证（1-存在；0-不存在）
	 */
	private Integer healthResult4;
	/**
	 * 最近一次体检机构名
	 */
	private String healthOrg;
	/**
	 * 最近一次体检日期
	 */
	private java.util.Date healthDate;
	/**
	 * 体检：已体检人次
	 */
	private Integer healthNum;
	/**
	 * 体检：未体检人数
	 */
	private Integer healthNum1;
	/**
	 * 体检：体检即将到期人数
	 */
	private Integer healthNum2;
	/**
	 * 体检：疑是职业病
	 */
	private Integer healthNum3;
	/**
	 * 体检：职业禁忌证
	 */
	private Integer healthNum4;
	/**
	 * 体检：未处置人员
	 */
	private Integer healthNum5;
	/**
	 * 职业病：当年新增职业病人数
	 */
	private Integer diseaseAddNum;
	/**
	 * 职业病：累计职业病人数
	 */
	private Integer diseaseNum;
	/**
	 * 个人剂量监测
	 */
	private Integer doseNum;
	/**
	 * 累计大剂量调查人数
	 */
	private Integer bigDoseNum;

	/**
	 * 需大剂量调查人数
	 */
	private Integer bigDoseNum2;
	/**
	 * 本年度监督次数
	 */
	private Integer superviseTimes;
	/**
	 * 本年度执法次数
	 */
	private Integer enforcementTimes;
	/**
	 * 证书预警状态
	 */
	private Integer certWarning;
	/**
	 * 年份
	 */
	private Integer years;

	/** 风险化解完成情况：许可管理 （eg：1/2）*/
	public String getHarmCert() {
		return harmCertDone + "/" + harmCertTotal;
	}
	/** 风险化解完成情况：性能检测 （eg：1/2）*/
	public String getHarmCheckDevice() {
		return harmCheckDeviceDone + "/" + harmCheckDeviceTotal;
	}
	/** 风险化解完成情况：职业健康体检 （eg：1/2）*/
	public String getHarmCheckLocation() {
		return harmCheckLocationDone + "/" + harmCheckLocationTotal;
	}
	/** 风险化解完成情况：性能检测 （eg：1/2）*/
	public String getHarmHealth() {
		return harmHealthDone + "/" + harmHealthTotal;
	}
	/** 风险化解完成情况：放射防护培训（eg：1/2）*/
	public String getHarmTraining() {
		return harmTrainingDone + "/" + harmTrainingTotal;
	}
	/** 风险化解完成情况：个人剂量监测 （eg：1/2）*/
	public String getHarmDose() {
		return harmDoseDone + "/" + harmDoseTotal;
	}
	/** 风险化解完成情况：三同时 （eg：1/2）*/
	public String getHarmThird() {
		return harmThirdDone + "/" + harmThirdTotal;
	}
}
