package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.io.Serializable;

/**
 * 详细异常-设备
 * @author chuhy
 * @date 2025/10/14 9:48
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("b_company_error_device")
public class BCompanyErrorDevice extends BaseEntity implements Serializable {
    @Serial
    private static final long serialVersionUID = -4357330313292370032L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    private Long cid;

    /**
     * 设备id（e_device.id）
     */
    private Long did;

    /**
     * BCompanyErrorDeviceCodeEnum
     */
    private Integer errCode;


    public BCompanyErrorDevice(Long cid, Long did, Integer errCode) {
        this.id = IdWorker.getId();
        this.cid = cid;
        this.did = did;
        this.errCode = errCode;
    }

    public BCompanyErrorDevice() {
    }
}
