package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 医院：基础信息异常表
 * </p>
 *
 * @author author
 * @since 2025-10-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_company_error")
public class BCompanyError extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @TableField("cid")
    private Long cid;

    /**
     * 医院名称 0正常 1空
     */
    @TableField("hospital_name_err")
    private Integer hospitalNameErr;

    /**
     * 院区名称 0正常 1空
     */
    @TableField("name_err")
    private Integer nameErr;

    /**
     * 信用代码 0正常 1空 2格式错误
     */
    @TableField("credit_code_err")
    private Integer creditCodeErr;

    /**
     * 机构类别 0正常 1空 2机构类别为“诊所”，但未选择“是否口腔诊所”
     */
    @TableField("type_err")
    private Integer typeErr;

    /**
     * 床位数 0正常 1空
     */
    @TableField("floor_num_err")
    private Integer floorNumErr;

    /**
     * 注册地址 0正常 1空 2未精确到街道一级
     */
    @TableField("registered_area_id_err")
    private Integer registeredAreaIdErr;

    /**
     * 注册地址_详情 0正常 1空
     */
    @TableField("registered_address_err")
    private Integer registeredAddressErr;

    /**
     * 执业地址 0正常 1空 2未精确到街道一级
     */
    @TableField("area_id_err")
    private Integer areaIdErr;

    /**
     * 执业地址_详情 0正常 1空
     */
    @TableField("address_err")
    private Integer addressErr;

    /**
     * 法定代表人_姓名 0正常 1空
     */
    @TableField("legal_name_err")
    private Integer legalNameErr;

    /**
     * 法定代表人_手机 0正常 1空 2格式错误
     */
    @TableField("legal_tel_err")
    private Integer legalTelErr;

    /**
     * 主要负责人_姓名 0正常 1空
     */
    @TableField("main_leader_name_err")
    private Integer mainLeaderNameErr;

    /**
     * 主要负责人_手机 0正常 1空 2格式错误
     */
    @TableField("main_leader_tel_err")
    private Integer mainLeaderTelErr;

    /**
     * 放射人员：0正常 1人员列表为空
     */
    @TableField("org_err")
    private Integer orgErr;

    /**
     * 放射人员：0正常 1人员列表为空
     */
    @TableField("staff_ray_err")
    private Integer staffRay;

    /**
     * 放射人员_在岗情况：0正常 1存在放射人员但不是上岗状态
     */
    @TableField("staff_ray_on_post_err")
    private Integer staffRayOnPostErr;
    /**
     * 人员异常表_放射人员(0正常 1异常)
     */
    @TableField("staff_ray_err_table_err")
    private Integer staffRayErrTableErr;

    /**
     * 放射防护管理领导小组_机构名称(0正常 1领导机构名称为空)
     */
    @TableField("ray_group_org_name_err")
    private Integer rayGroupOrgNameErr;

    /**
     * 放射防护管理领导小组_部门名称(0正常 1部门名称为空)
     */
    @TableField("ray_group_department_name_err")
    private Integer rayGroupDepartmentNameErr;

    /**
     * 放射防护管理领导小组_成立文件(0正常 1成立文件为空)
     */
    @TableField("ray_group_founding_file_err")
    private Integer rayGroupFoundingFileErr;

    /**
     * 放射管理人员列表（0正常 列表为空）
     */
    @TableField("manager_err")
    private Integer managerErr;

    /**
     * 放射管理人员列表_手机号（0正常 1空 2格式不正确）
     */
    @TableField("manager_phone_err")
    private Integer managerPhoneErr;
    /**
     * 放射管理人员列表_手机号_格式（0正常 1格式不正确）
     */
    @TableField("manager_phone_format_err")
    private Integer managerPhoneFormatErr;

    /**
     * 机房（0-正常；1-空；2-已启用场所数为0）
     */
    @TableField("e_machine_room_err")
    private Integer eMachineRoomErr;

    /**
     * 机房异常数量
     */
    @TableField("e_machine_room_err_num")
    private Integer eMachineRoomErrNum;

    /**
     * 装置/同位素（0-正常；1-存在异常）
     */
    @TableField("e_device_err")
    private Integer eDeviceErr;

    /**
     * 装置/同位素异常数量
     */
    @TableField("e_device_err_num")
    private Integer eDeviceErrNum;


}
