package cn.smarthse.rho.modules.sys.entity.b;


import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName("b_company_bulletin")
public class BCompanyBulletin extends BaseEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 企业Id
     */
    @TableField(value = "cid")
    private Long cid;

    /**
     * 制度/规程 名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 附件类型：1=管理制度，2=操作规程
     */
    @TableField(value = "type")
    private Integer type;

    /**
     * 管理制度编号（CompanyCategoryCodeEnum）
     */
    @TableField(value = "category_code")
    private Integer categoryCode;

    /**
     * 附件id
     */
    @TableField(value = "file_id")
    private Long fileId;

}