package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
*
*
* @Author: czq
* @Creat: 2025-08-22 16:25
*/

/**
 * 医院-院区执业地址表
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "b_company_address")
public class BCompanyAddress extends BaseEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 院区id
     */
    @TableField(value = "cid")
    private Long cid;
    /**
     * 执业地址名称
     */
    @TableField(value = "name")
    private String name;
    /**
     * 工作地址行政区划
     */
    @TableField(value = "area_id")
    private Long areaId;

    /**
     * 工作作地址详情（eg：水墩新路88号）
     */
    @TableField(value = "address")
    private String address;

    /**
     * 是否是院区主执业地址（1-是；0-否）
     */
    @TableField(value = "is_main")
    private Integer isMain;

    @TableField(exist = false)
    private Integer level;
}