package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 医院：基础信息
 *
 * @author chenliang
 * @since 2024-03-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("b_company")
public class BCompany extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    private Long id;

    @TableField("out_id")
    private String outId;
    /**
     * 职卫云id
     */
    @TableField("zwy_hospital_id")
    private String zwyHospitalId;

    /**
     * 同步时间
     */
    @TableField("sync_time")
    private LocalDateTime syncTime;

    /**
     * 入库时间
     */
    @TableField("entry_time")
    private LocalDateTime entryTime;

    /**
     * 入库时间(年)
     */
    @TableField("entry_year")
    private LocalDateTime entryYear;

    /**
     * 入库时间（月）
     */
    @TableField("entry_month")
    private LocalDateTime entryMonth;

    /**
     * 入库时间(第某次)
     */
    @TableField("entry_no")
    private Integer entryNo;

    /**
     * 职卫云加载时间
     */
    @TableField("wanda_load_time")
    private LocalDateTime wandaLoadTime;

    /**
     * 来源id
     */
    @TableField("source_id")
    private String sourceId;

    /**
     * 全国统一码
     */
    @TableField("medical_nucode")
    private String medicalNucode;
    /**
     * 医疗机构执业许可证号
     */
    @TableField("mip_license_number")
    private String mipLicenseNumber;

    /**
     * 是否是主院
     */
    @TableField("is_main")
    private Integer isMain;

    /**
     * 主院id
     */
    @TableField("main_id")
    private Long mainId;

    /**
     * 主院名称
     */
    @TableField("main_name")
    private String mainName;

    /**
     * 所在医院id
     */
    @TableField("hospital_id")
    private Long hospitalId;

    /**
     * 所在医院名称
     */
    @TableField("hospital_name")
    private String hospitalName;

    /**
     * 医院名称
     */
    @TableField("name")
    private String name;

    /**
     * 统一社会信用代码
     */
    @TableField("credit_code")
    private String creditCode;

    /**
     * 机构类型
     */
    @TableField("type")
    private Integer type;

    @TableField("type2")
    private Integer type2;

    //0普通 1多执业地址
    @TableField("address_type")
    private Integer addressType;

    /**
     * 经济类型
     */
    @TableField("economy_code")
    private Integer economyCode;

    /**
     * 医院等级
     */
    @TableField("unit_level")
    private Integer unitLevel;

    /**
     * 经营性质
     */
    @TableField("business_type")
    private Integer businessType;

    /**
     * 营业状态
     */
    @TableField("business_status")
    private Integer businessStatus;

    /**
     * 许可证状态（1-正常；0-注销）
     */
    @TableField("licence_status")
    private Integer licenceStatus;

    /**
     * 院区状态（1-开启；0-关闭）
     */
    private Integer state;

    /**
     * 床位数
     */
    @TableField("floor_num")
    private Integer floorNum;

    /**
     * 工作地址行政区划
     */
    @TableField("area_id")
    private Long areaId;

    /**
     * 工作地址详情（eg：水墩新路88号）
     */
    @TableField("address")
    private String address;

    /**
     * 工作地址完整（eg：浙江省杭州市上城区笕桥街道水墩新路88号）
     */
    @TableField("full_address")
    private String fullAddress;

    /**
     * 注册地址id
     */
    @TableField("registered_area_id")
    private Long registeredAreaId;

    /**
     * 注册地址详情
     */
    @TableField("registered_address")
    private String registeredAddress;

    /**
     * 注册地址完整
     */
    @TableField("registered_full_address")
    private String registeredFullAddress;

    /**
     * 法人代表姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    @TableField("legal_name")
    private String legalName;

    /**
     * 法人代表联系电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @TableField("legal_tel")
    private String legalTel;

    /**
     * 主要负责人
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    @TableField("main_leader_name")
    private String mainLeaderName;

    /**
     * 主要负责人手机号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @TableField("main_leader_tel")
    private String mainLeaderTel;

    /**
     * 监督管辖类型（0-属地管辖 1-特殊管辖）
     */
    @TableField("supervisory_jurisdiction_type")
    private Integer supervisoryJurisdictionType;

    /**
     * 直属类型：0非直属， 1省直属，2市属
     */
    @TableField("belong_type")
    private Integer belongType;

    /**
     * 监督单位
     */
    @TableField("supervision_unit")
    private Long supervisionUnit;

    /**
     * 监督单位区域
     */
    @TableField("supervision_area_id")
    private Long supervisionAreaId;

    /**
     * 是否是测试
     */
    @TableField("is_test")
    private Integer isTest;

    @TableField("is_pilot_unit")
    private Integer isPilotUnit;

    /**
     * CmSourceEnum
     */
    @TableField("source")
    private Integer source;

    /**
     * 是否需要创建账号
     */
    @TableField(exist = false)
    private Integer needAddAccount;

    /**
     * b_company_error表id
     */
    @TableField(exist = false)
    private Long errorId;

}
