package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 许可变更操作记录
 * </p>
 *
 * @author author
 * @since 2025-10-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_change_license_opt_log")
public class BChangeLicenseOptLog extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 许可变更id
     */
    private Long licenseId;

    /**
     * 操作类型（0-提交；1-确认；2-退回；3-终止）
     */
    private Integer type;

    private Integer beforeStatus;
    private Integer afterStatus;

    /**
     * 退回理由
     */
    private String returnReason;

    /**
     * Supporting Documents佐证材料文件id
     */
    private Long sdFileId;

    /**
     * 操作人id
     */
    private Long optId;

    /**
     * 操作人
     */
    private String optor;




}
