package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("b_change_license_device_relation")
public class BChangeLicenseDeviceRelation extends BaseEntity implements Serializable{
	@Serial
	private static final long serialVersionUID = 7183816065779958321L;
	

    @TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;

	/**
	 * 许可id（b_change_license.id）
	 */
	private Long licenseId;


	/**
	 * 关联关系id(e_relation.id)
	 */
	private Long erId;
	
	/**
	 * 放射源/核素id
	 */
	private Long sourceId;
	
	/**
	 * 机房id
	 */
	private Long roomId;
	
	/**
	 * 设备id
	 */
	private Long deviceId;

	/**
	 * 变更日期
	 */
	private LocalDateTime changeDate;
	
	/**
	 * 是否已变更到e_relation(1-是)
	 */
	private Integer isMigrated;

	/**
	 * 三同时项目id（f_project.id）
	 */
	private Long projectId;

	/**
	 * 批次id
	 */
	private Long batchId;

	/**
	 * 变更前装置/机房名称
	 */
	private String beforeChangeName;

	/**
	 * 变更后装置/机房名称
	 */
	private String afterChangeName;

	/**
	 * 操作人name
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String operatorName;



}
