package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;



/**
 * <p>
 * 许可校验表
 * </p>
 *
 * @author chenliang
 * @since 2024-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_change_license")
public class BChangeLicense extends BaseEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 2599855495296948549L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    //公司id
    private Long cid;

    //类型（LicenseChangeTypeEnum）
    private String type;

    //类型（LicenseChangeTypeEnum）
    private String subType;

    //标题
    private String title;

    //业务id（公司id 或者 设备id）
    private Long targetId;

    //许可生成时间
    private LocalDateTime genTime;

    //佐证材料
    private Long sdFileId;

    //状态(LicenseStatusEnum)
    private Integer adminLicenseStatus;

    //监管确认时间
    private LocalDateTime adminLicenseTime;

    //监管id
    private Long adminLicenseId;

    // 是否处于流程中（1-是）
    private Integer isCur;


    // ******************废弃***********************
    //是否需要许可
    private Integer needLicense;
    //变更前值
    private String beforeValue;
    //变更后值
    private String afterValue;


}
