package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;



/**
 * <p>
 * 
 * </p>
 *
 * @author chenliang
 * @since 2024-04-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_cert_change_log")
//@ApiModel(value="BCertChangeLog对象", description="")
public class BCertChangeLog extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    //@ApiModelProperty(value = "同步时间（指的是wanda的同步时间，不是这条数据的更新时间）")
    @TableField("sync_time")
    private LocalDateTime syncTime;

    //@ApiModelProperty(value = "来源id")
    @TableField("source_id")
    private String sourceId;

    //@ApiModelProperty("全国统一码")
    @TableField("medical_nucode")
    private String medicalNucode;

    //@ApiModelProperty("信用代码")
    @TableField("credit_code")
    private String creditCode;

    //@ApiModelProperty(value = "院区名称")
    @TableField("company_name")
    private String companyName;

    //@ApiModelProperty(value = "校验日期")
    @TableField("verification_date")
    private LocalDateTime verificationDate;

    //@ApiModelProperty(value = "校验类型，同步数据，枚举未定")
    @TableField("type")
    private String type;

    //@ApiModelProperty(value = "许可编号")
    @TableField("cert_no")
    private String certNo;

    //@ApiModelProperty(value = "监督机构id")
    @TableField("supervisory_org_id")
    private Long supervisoryOrgId;

    //@ApiModelProperty(value = "监督机构名称")
    @TableField("supervisory_org_name")
    private String supervisoryOrgName;

    //@ApiModelProperty(value = "来源(1wanda)")
    @TableField("source")
    private Integer source;


}
