package cn.smarthse.rho.modules.sys.entity.a;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 监管：统计（只存第四级数据）
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AStatistic extends BaseEntity {
    private static final long serialVersionUID = -7240860869285236072L;

    @TableId
    private Long id;
    /**
     * 年份
     */
    private Integer years;

    /**
     * 企业行政区划名称级联（eg：浙江省-杭州市-上城区-笕桥街道）
     */
    private String areaCascade;

    /**
     * 行政区划id
     */
    private Long areaId;

    /**
     * 行政区划省id
     */
    private Long areaId1;

    /**
     * 行政区划市id
     */
    private Long areaId2;

    /**
     * 行政区划区县id
     */
    private Long areaId3;

    /**
     * 行政区划街道id
     */
    private Long areaId4;

    /**
     * 行政区划等级
     */
    private Integer level;

    /**
     * 风险总数
     */
    private Integer harmNumTotal;

    /**
     * 风险已化解数
     */
    private Integer harmNumFixTotal;

    /**
     * 风险已化解数（首次预警）
     */
    private Integer harmNumFix1;

    /**
     * 风险已化解数（黄色预警）
     */
    private Integer harmNumFix2;

    /**
     * 风险已化解数（红色预警）
     */
    private Integer harmNumFix3;

    /**
     * 风险已化解数（启动执法）
     */
    private Integer harmNumFix4;

    /**
     * 风险未化解数（首次预警）
     */
    private Integer harmNumUnfix1;

    /**
     * 风险未化解数（黄色预警）
     */
    private Integer harmNumUnfix2;

    /**
     * 风险未化解数（红色预警）
     */
    private Integer harmNumUnfix3;

    /**
     * 风险未化解数（启动执法）
     */
    private Integer harmNumUnfix4;

    /**
     * 风险首次预警数
     */
    private Integer harmNumWarning1;

    /**
     * 风险黄色预警数
     */
    private Integer harmNumWarning2;

    /**
     * 风险红色预警数
     */
    private Integer harmNumWarning3;

    /**
     * 风险启动执法数
     */
    private Integer harmNumWarning4;

    /**
     * 需画像医院数（家）
     */
    private Integer needPortraitCompanyNum;

    /**
     * 画像后暂无风险医院数（家）
     */
    private Integer riskFreeCompanyNum;

    /**
     * 画像后有风险医院数（家）
     */
    private Integer riskyCompanyNum;

    /**
     * 未化解风险院区数(家)
     */
    private Integer unfixCompanyNum;

    /**
     * 已化解风险院区数(家)
     */
    private Integer fixedCompanyNum;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 区县名称
     */
    private String areaName;

    /**
     * 乡镇街道名称
     */
    private String streetName;
}
