package cn.smarthse.rho.modules.sys.converter.b;

import cn.smarthse.rho.modules.sys.entity.b.BChangeLicenseDeviceRelation;
import cn.smarthse.rho.modules.sys.entity.e.ERelation;
import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import cn.smarthse.rho.modules.sys.model.e.vo.ERelationVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 核素-机房-设备对应关系Converter
 */
@Mapper(componentModel = "spring")
public interface BChangeLicenseDeviceRelationConverter {
    BChangeLicenseDeviceRelationConverter INSTANCE = Mappers.getMapper(BChangeLicenseDeviceRelationConverter.class);

    /**
     * 基础实体转vo
     */
    ERelationVo baseEntity2Vo(ERelation entity);


    /**
     * dto转基础实体
     */
    ERelation baseDto2Entity(ERelationDto dto);

    /**
     * list - dto转基础实体
     */
    List<ERelation> dtoList2EntityList(List<ERelationDto> dto);

    /**
     * dto 转 待审核关系
     */
    @Mappings({
            @Mapping(target = "id", ignore = true),
            @Mapping(source = "id", target = "erId")
    })
    BChangeLicenseDeviceRelation dto2LicenseRelation(ERelationDto dto);
    List<BChangeLicenseDeviceRelation> dtoList2LicenseRelationList(List<ERelationDto> dtoList);


}