/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.enums.staff;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum RayCodeEnum {
    NUCLEAR("1", "\u6838\u71c3\u6599\u5faa\u73af"),
    NUCLEAR_A("1A", "\u94c0\u77ff\u5f00\u91c71A"),
    NUCLEAR_B("1B", "\u94c0\u77ff\u6c34\u6cbb1B"),
    NUCLEAR_C("1C", "\u94c0\u7684\u6d53\u7f29\u548c\u8f6c\u53161C"),
    NUCLEAR_D("1D", "\u71c3\u6599\u5236\u90201D"),
    NUCLEAR_E("1E", "\u53cd\u5e94\u58061E"),
    NUCLEAR_F("1F", "\u71c3\u6599\u540e\u5904\u74061F"),
    NUCLEAR_G("1G", "\u6838\u71c3\u6599\u5faa\u73af\u7814\u7a761G"),
    MEDICINE("2", "\u533b\u5b66\u5e94\u7528"),
    MEDICINE_A("2A", "\u8bca\u65ad\u653e\u5c04\u5b662A"),
    MEDICINE_B("2B", "\u7259\u79d1\u653e\u5c04\u5b662B"),
    MEDICINE_C("2C", "\u6838\u533b\u5b662C"),
    MEDICINE_D("2D", "\u653e\u5c04\u6cbb\u75972D"),
    MEDICINE_E("2E", "\u4ecb\u5165\u653e\u5c04\u5b662E"),
    MEDICINE_F("2F", "\u5176\u4ed62F"),
    INDUSTRY("3", "\u5de5\u4e1a\u5e94\u7528"),
    INDUSTRY_A("3A", "\u5de5\u4e1a\u8f90\u5c043A"),
    INDUSTRY_B("3B", "\u5de5\u4e1a\u63a2\u4f243B"),
    INDUSTRY_C("3C", "\u53d1\u5149\u6d82\u6599\u5de5\u4e1a3C"),
    INDUSTRY_D("3D", "\u653e\u5c04\u6027\u540c\u4f4d\u7d20\u751f\u4ea73D"),
    INDUSTRY_E("3E", "\u6d4b\u4e953E"),
    INDUSTRY_F("3F", "\u52a0\u901f\u5668\u8fd0\u884c3F"),
    INDUSTRY_G("3G", "\u5176\u4ed63G"),
    NATURE("4", "\u5929\u7136\u6e90"),
    NATURE_A("4A", "\u6c11\u7528\u822a\u7a7a4A"),
    NATURE_B("4B", "\u7164\u77ff\u5f00\u91c74B"),
    NATURE_C("4C", "\u5176\u4ed6\u77ff\u85cf\u5f00\u91c74C"),
    NATURE_D("4D", "\u77f3\u6cb9\u548c\u5929\u7136\u6c14\u5de5\u4e1a4D"),
    NATURE_E("4E", "\u77ff\u7269\u548c\u77ff\u77f3\u5904\u74064E"),
    NATURE_F("4F", "\u5176\u4ed64F"),
    OTHER("5", "\u5176\u4ed6"),
    OTHER_A("5A", "\u6559\u80b25A"),
    OTHER_B("5B", "\u517d\u533b\u5b665B"),
    OTHER_C("5C", "\u79d1\u5b66\u7814\u7a765C"),
    OTHER_D("5D", "\u5176\u4ed65D");

    private String code;
    private String name;

    public static String getCode(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        for (RayCodeEnum c : RayCodeEnum.values()) {
            if (!c.getName().equals(name)) continue;
            return c.code;
        }
        return null;
    }

    public static String getCodeByFuzzyName(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        for (RayCodeEnum c : RayCodeEnum.values()) {
            if (!c.getName().contains(name)) continue;
            return c.code;
        }
        return null;
    }

    public static String getName(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return null;
        }
        for (RayCodeEnum c : RayCodeEnum.values()) {
            if (!c.getCode().equals(code)) continue;
            return c.name;
        }
        return null;
    }

    private RayCodeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

