package cn.smarthse.rho.modules.sys.utils;

import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;

import javax.smarthse.framework.exception.ServiceException;

/**
 * @Classname AreaUtils
 * @Description chenliang
 * @Date 2023/10/7 9:39
 * @Author chenliang
 */
public class AreaUtils {


    public static SysAreaVo analysisAreaPermissions(SysAreaVo loginUserArea, SysAreaVo paramArea){
        if(loginUserArea == null){
            throw new ServiceException("登录账号无区域数据");
        }else {
            if(paramArea == null){//如果参数区域id为空，就返回账号区域id
                return loginUserArea;
            }
        }


        if(loginUserArea.getLevel() >= paramArea.getLevel()){//账号区域等级小于等于参数区域等级
            return loginUserArea;
        }else if(loginUserArea.getLevel() < paramArea.getLevel()) {//账号区域等级大于参数区域等级
            if(loginUserArea.getLevel() == 0){
                return paramArea;
            }else if(loginUserArea.getLevel() == 1){
                return loginUserArea.getProvinceId().equals(paramArea.getProvinceId()) ? paramArea : loginUserArea;
            }else if(loginUserArea.getLevel() == 2){
                return loginUserArea.getCityId().equals(paramArea.getCityId()) ? paramArea : loginUserArea;
            }else if(loginUserArea.getLevel() == 3){
                return loginUserArea.getAreaId().equals(paramArea.getAreaId()) ? paramArea : loginUserArea;
            }else if(loginUserArea.getLevel() == 4){
                return loginUserArea.getStreetId().equals(paramArea.getStreetId()) ? paramArea : loginUserArea;
            }else {
                throw new ServiceException("区域比对未知错误");
            }
        }else {
            throw new ServiceException("区域比对未知错误");
        }
    }
}
