package cn.smarthse.rho.modules.sys.provider.zlb;

/**
 * 浙里办身份认证
 *
 * @author ShenZQ
 * @since 2022/12/7 15:40
 */
public interface IZlbClientServiceService {


    /**
     * 获取浙里办单点登录token
     *
     * @param ticketId
     * @param appKey
     * @param appSecret
     * @return {@link String}
     * @author ShenZQ
     * @since 2023/8/31 9:52
     */
    String getClientTicketCode(String ticketId, String appKey, String appSecret, String appId);

    /**
     * 获取浙里办用户信息
     *
     * @param token
     * @param appKey
     * @param appSecret
     * @return {@link ZlbUserInfo}
     * @author ShenZQ
     * @since 2023/8/31 11:05
     */
    ZlbUserInfo getClientInfoByToken(String token, String appKey, String appSecret);

    ZlbUserInfo getZlbUserInfo(String ticket, String appId);
}