package cn.smarthse.rho.modules.sys.provider.sys;

import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.IdsParam;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.model.sys.param.*;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForComVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForSupVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyOneForComVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyOneForSupVo;

import java.util.List;

public interface ISysUserServiceProvider {

    /**
     * 查询单位用户列表（分页）
     *
     * @param param
     * @return {@link LayuiGridData<SysUserCompanyListForSupVo>}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/15 13:23
     */
    LayuiGridData<SysUserCompanyListForSupVo> getSysCompanyUserListForSup(SysCompanyUserListParam param);

    LayuiGridData<SysUserCompanyListForComVo> getSysCompanyUserListForCom(SysCompanyUserListParam param);

    /**
     * 用户详情
     *
     * @param userId 账号id
     * @return {@link SysUserCompanyOneForSupVo}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/30 11:23
     */
    SysUserCompanyOneForSupVo getSysUserCompanyByUserIdForSup(Long userId);

    SysUserCompanyOneForSupVo getSysUserCompanyByCidForSup(Long cid);

    SysUserCompanyOneForComVo getSysUserCompanyByUserIdForCom(Long userId);

    /**
     * 编辑
     */
    Boolean updateSysCompanyUserEditForSup(SysCompanyUserEditForSupParam param);

    Boolean updateSysCompanyUserEditForCom(SysCompanyUserEditForComParam param);

    /**
     * 禁用、启用
     *
     * @param param
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/24 15:01
     */
    Boolean updateSysCompanyUserStatueForSup(SysCompanyUserStatueEditForSupParam param);

    /**
     * 批量修改状态
     */
    Boolean updateSysCompanyUserExcludeSingleUserStatueByCidListForSup(SysCompanyUserStatueEditByCidListForSupParam param);

    Boolean updateSysCompanyUserStatueForCom(SysCompanyUserStatueEditForComParam param);

    /**
     * 重置密码（默认密码为Zyj@2022）
     *
     * @param param
     * @return int
     * @author liaoly
     * @date 2021年9月15日 下午12:32:40
     */
    Boolean resetPasswordForSup(IdParam param);

    Boolean resetPasswordForCom(IdParam param);

    /**
     * 根据userId查询
     *
     * @param userId 账号id
     * @return {@link SysUser}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/30 11:23
     */
    SysUser getUserById(Long userId);

    /**
     * 根据cid查询
     */
    List<SysUser> getUserListByCid(Long cid);

    /**
     * 根据cid查询管理员
     */
    SysUser getManagerUserByCid(Long cid);

    /**
     * 根据username查询
     *
     * @param username 账号
     * @return {@link SysUser}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/3 10:54
     */
    SysUser getUserByUsername(String username);

    /**
     * 根据旧密码修改密码
     *
     * @param userId      账号id
     * @param oldPassword 旧密码 md5 32位小写
     * @param newPassword 新密码 md5 32位小写
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/3 11:14
     */
    void changePassword(Long userId, String oldPassword, String newPassword);

    /**
     * 创建单位账号，用于单点登录
     *
     * @param cid          单位id
     * @param username     账号名
     * @param userResource
     * @return {@link SysUser}
     * @author chuhy
     * @date 2024/6/24 13:56
     */
    SysUser addUserForCas(Long cid, String username, Integer userResource);

    Boolean addUserForSup(SysCompanyUserCreateEditParam param);

    Boolean addUserByCidListForSup(IdsParam param);

    /**
     * 单位端：系统模块-用户管理：用户添加
     *
     * @param param
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/3 10:18
     */
    Boolean addUserForCom(SysCompanyUserAddForComParam param);

    /**
     * 根据cid删除
     */
    Boolean deleteSysCompanyUserByCidListForSup(IdsParam param);

    /**
     * 根据userId删除
     */
    Boolean deleteSysCompanyUserByUserIdForCom(IdParam param);

    /**
     * 超过三个月没修改过密码的用户提醒修改密码
     */
    void updatePassStateThreeMonth();

}
