package cn.smarthse.rho.modules.sys.provider.sys;

import cn.smarthse.rho.modules.sys.model.sys.vo.SysRoleVo;

import java.util.List;
import java.util.Set;

public interface ISysRoleServiceProvider {

    /**
     * 获取角色数据权限
     *
     * @param userId 用户id
     * @return 角色权限信息
     */
    Set<String> selectRolePermissionByUserId(Long userId);

    /**
     * 查询某用户所赋予角色列表
     *
     * @param userId : 账号id
     * @return SysRoleVo
     * @author liaoly
     * @date 2020年9月1日 下午1:38:54
     */
    List<SysRoleVo> getRoleListByUserId(Long userId);

    /**
     * 根据userId查询系统角色+自定义角色
     *
     * @param userId
     * @return List<SysRoleVo>
     * @author liaoly
     * @date 2021年11月17日 上午9:53:28
     */
    List<SysRoleVo> getSelectedRoleListByUserId(Long userId);

}
