package cn.smarthse.rho.modules.sys.provider.sys;

import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaTreeVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo2;
import java.util.List;
import java.util.Map;

/**
 * 行政区划接口
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/3/15 14:55
 */
public interface ISysAreaProvider {

    /**
     * 查询区域详情
     *
     * @param areaId 区域id
     * @return {@link SysAreaVo}
     * @author liaoly
     * @date 2022/3/7 13:17
     */
    SysAreaVo getAreaById(Long areaId);

    /**
     * 查询区域详情 附带每一级行政区划下拉选项列表
     *
     * @param areaId 区域id
     * @return {@link Map<String, Object>}
     * @author liaoly
     * @date 2022/3/7 13:17
     */
    SysAreaVo2 getAreaByIdV2(Long areaId);

    /**
     * 获取区域名称
     * @param areaId 区域id
     * @return 区域名称
     */
    String getAreaNameById(Long areaId);

    /**
     * 查询指定pid的下级行政区划
     *
     * @param pid
     * @return {@link List <  SysAreaVo  >}
     * @author liaoly
     * @date 2022/3/16 8:37
     */
    List<SysAreaVo> getAreaList(Long pid);

    /**
     * 查询指定pid的下级行政区划
     *
     * @param pid
     * @return {@link List<  SysAreaTreeVo  >}
     * @author liaoly
     * @date 2022/3/16 8:36
     */
    List<SysAreaTreeVo> getAreaTreeList(Long pid);

    /**
     *
     * 查询指定行政区划的详细名称（eg：浙江省>杭州市>上城区）
     *
     * @author liaoly
     * @date 2021年9月14日 下午3:55:54
     * @param areaId : 行政区划id
     * @param linkCode : 链接字符串
     * @return String
     */
    String getAreaAddress(Long areaId, String linkCode);

    /**
     *
     * 查询指定行政区划的详细名称（eg：浙江省>杭州市>上城区）
     *
     * @author liaoly
     * @date 2021年9月14日 下午3:55:54
     * @param areaId : 行政区划id
     * @return String
     */
    String getAreaAddress(Long areaId);

    /**
     * 根据特殊结构的行政区划中文地址(eg：浙江省>杭州市>上城区>笕桥街道>中山路24号) 查询行政区划id
     * @param areaAddressList
     * @return {@link Map <String, Long>}
     * @author liaoly
     * @date 2022/3/21 16:55
     */
    Map<String, Long> getByAreaAddress(List<String> areaAddressList);

    /**
     * 根据特殊结构的行政区划中文地址(eg：浙江省>杭州市>上城区>笕桥街道>中山路24号) 查询行政区划id
     * @param areaAddress
     * @return {@link Long}
     * @author liaoly
     * @date 2022/3/21 16:55
     */
    Long getByAreaAddress(String areaAddress);

    /**
     * 查询行政区划等级 国家-0 省-1 市-2 。。。
     * @param areaId 行政区划
     * @return {@link Integer}
     * @author liaoly
     * @date 2022/9/5 9:00
     */
    Integer getLevel(Long areaId);
    /**
     * 校验当前账号是否有权限（校验当前账号的行政区划 是否是 下级行政区划 or 相同，是的话返回true）
     * @param childAreaId 下级areaId（被操作资源的areaId）
     * @param parentId 上级areaId（包括非直接上级）（当前账号的areaId）
     * @return {@link boolean}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/24 15:54
     */
    boolean hasPermission(Long childAreaId, Long parentId);

    /**
     * 区域分析
     * @Author ChenLiang
     * @Date 15:17 2024/7/22
     * @param loginUserAreaId 登录用户的区域
     * @param paramAreaId 前端传递的区域
     * @return SysAreaVo
     */
    SysAreaVo analysisAreaPermissions(Long loginUserAreaId, Long paramAreaId);


    /**
     * 根据区域id下所有的区域数据。
     * 如：areaId为330000000000，查的是浙江省下的所有行政区划数据
     * @param areaId
     * @return {@link SysAreaVo}
     * @author chuhy
     * @date 2024/7/23 15:23
     */
    List<SysAreaVo> getSubAreaByIdAndLevel(Long areaId);
}
